/*
 * Decompiled with CFR 0.152.
 */
package com.instalments.domain.use_case;

import com.dao.PaymentDao;
import com.dao.SarfaslDao;
import com.doc.data.DocumentDao;
import com.dto.LoginDto;
import com.dto.PaymentDto;
import com.instalments.data.InstalmentDao;
import com.instalments.domain.InstalmentDto;
import com.instalments.domain.InstalmentSettleDto;
import com.instalments.domain.use_case.CheckInstalmentSettleErrors;
import com.instalments.domain.use_case.InsertInstalmentProcess;
import com.instalments.domain.use_case.MakeInstalmentDocDtl;
import com.instalments.domain.use_case.SettleInstalment;
import com.security.SecurityConstants;
import com.utility.ConvertStr;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import org.springframework.stereotype.Service;

@Service
public class SettleInstalment {
    private final CheckInstalmentSettleErrors checkErrors;
    private final InstalmentDao dao;
    private final PaymentDao paymentDao;
    private final DocumentDao documentDao;
    private final SarfaslDao headingDao;
    private final InsertInstalmentProcess instalmentProcess;
    private InstalmentDto currentInstalment;

    public InstalmentSettleResult invoke(InstalmentSettleDto settleDto) throws TncException {
        CheckInstalmentSettleErrors.InstalmentCheckErrorResult checkErrorResult = this.checkErrors.invoke(settleDto);
        this.currentInstalment = checkErrorResult.getCurrentInstalment();
        return new InstalmentSettleResult(this.doSettle(settleDto), checkErrorResult.isRemainderAddedToNext());
    }

    private PaymentDto doSettle(InstalmentSettleDto settleDto) {
        LoginDto login = SecurityConstants.loadToken();
        PaymentDto docData = this.makeDocumentData(settleDto, login);
        long docCode = this.paymentDao.doInsertSanad(0, docData, login);
        settleDto.setDocCode(docCode);
        MakeInstalmentDocDtl makeInstalmentDocDtl = new MakeInstalmentDocDtl(this.currentInstalment);
        this.documentDao.insertDocDtls(makeInstalmentDocDtl.invoke(settleDto, docData));
        this.dao.settle(settleDto);
        if (!login.getIsMyHoloo().booleanValue()) {
            settleDto.setOurPayment(this.currentInstalment.isOurPayment());
            settleDto.setDocCodeC(docData.getDocCode());
            this.instalmentProcess.invoke(settleDto);
        }
        return docData;
    }

    private PaymentDto makeDocumentData(InstalmentSettleDto settleDto, LoginDto login) {
        return PaymentDto.builder().id(String.valueOf(settleDto.getId())).date(settleDto.getSettleDate()).time(settleDto.getSettleTime()).bank(settleDto.getPos()).banksarfasl(settleDto.getPosHeading()).cash(settleDto.getCash()).cashsarfasl(settleDto.getCashHeading()).discount(settleDto.getDiscount()).customersarfasl(this.getCustomerHeading(settleDto.getCustomerCode(), login)).comment(settleDto.getComment() == null ? (this.currentInstalment.isOurPayment() ? "\u067e\u0631\u062f\u0627\u062e\u062a \u0627\u0642\u0633\u0627\u0637" : "\u062f\u0631\u06cc\u0627\u0641\u062a \u0627\u0642\u0633\u0627\u0637") : settleDto.getComment()).action(Integer.valueOf(0)).build();
    }

    private String getCustomerHeading(String customerCode, LoginDto login) {
        String headingCode = (String)this.headingDao.getCustomerCodeNamePairByCustomerCode(customerCode, login).getLeft();
        if (ConvertStr.isNullOrEmpty((String)headingCode)) {
            throw new TncException(TncExceptionMessages.INVALID_CUSTOMER_CODE);
        }
        return headingCode;
    }

    public SettleInstalment(CheckInstalmentSettleErrors checkErrors, InstalmentDao dao, PaymentDao paymentDao, DocumentDao documentDao, SarfaslDao headingDao, InsertInstalmentProcess instalmentProcess) {
        this.checkErrors = checkErrors;
        this.dao = dao;
        this.paymentDao = paymentDao;
        this.documentDao = documentDao;
        this.headingDao = headingDao;
        this.instalmentProcess = instalmentProcess;
    }
}

